﻿namespace Code6587EN.Ch06.ConfigureProductsList
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using Microsoft.SharePoint.Publishing;
    using Microsoft.SharePoint.Taxonomy;
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// Console Application to configure the Products list
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection that will contain the new Publishing Site
            using (var site = new SPSite("http://sharepoint/publishing"))
            {
                // Open a new taxonomy session from the site
	            var session = new TaxonomySession(site);

	            // Get the Products term set
	            var termStore = session.TermStores[0];
	            var group = termStore.Groups["Code Product Categories"];
	            var termSet = group.TermSets["Products"];

	            // Get the Products list
	            var list = site.RootWeb.Lists["Products"];

	            // Add a new metadata field to the Products list
	            var field = list.Fields.CreateNewField("TaxonomyFieldType", "Code Category") as TaxonomyField;
	            field.AnchorId = Guid.Empty;
	            field.SspId = termStore.Id;
	            field.Group = "Code Product Categories";
	            field.TermSetId = termSet.Id;
	            field.AllowMultipleValues = false;
	            list.Fields.Add(field);
	            list.Update();

	            // Get the Red, Green, and Blue terms from the Widgets term
	            var termWidgets = termSet.Terms["Widgets"];
	            var termRed = termWidgets.Terms["Red"];
	            var termGreen = termWidgets.Terms["Green"];
	            var termBlue = termWidgets.Terms["Blue"];

	            // Get the metadata field from the Products list
	            field = list.Fields["Code Category"] as TaxonomyField;

	            // Create taxonomy values for the Red, Green, and Blue terms
	            var valueRed = new TaxonomyFieldValue(field);
	            valueRed.TermGuid = termRed.Id.ToString();
	            valueRed.Label = termRed.Name;
	            var valueGreen = new TaxonomyFieldValue(field);
	            valueGreen.TermGuid = termGreen.Id.ToString();
	            valueGreen.Label = termGreen.Name;
	            var valueBlue = new TaxonomyFieldValue(field);
	            valueBlue.TermGuid = termBlue.Id.ToString();
	            valueBlue.Label = termBlue.Name;

	            // Add items to the list with the term values
	            var item001 = list.Items.Add();
	            item001["Title"] = "Code Widget A";
	            item001["Item Number"] = "C001";
	            item001["Code Category"] = valueBlue;
	            item001.Update();
	            var item002 = list.Items.Add();
	            item002["Title"] = "Code Widget B";
	            item002["Item Number"] = "C002";
	            item002["Code Category"] = valueBlue;
	            item002.Update();
	            var item003 = list.Items.Add();
	            item003["Title"] = "Code Widget C";
	            item003["Item Number"] = "C003";
	            item003["Code Category"] = valueRed;
	            item003.Update();
	            var item004 = list.Items.Add();
	            item004["Title"] = "Code Widget D";
	            item004["Item Number"] = "C004";
	            item004["Code Category"] = valueRed;
	            item004.Update();
	            var item005 = list.Items.Add();
	            item005["Title"] = "Code Widget E";
	            item005["Item Number"] = "C005";
	            item005["Code Category"] = valueGreen;
	            item005.Update();
	            var item006 = list.Items.Add();
	            item006["Title"] = "Code Widget F";
	            item006["Item Number"] = "C006";
	            item006["Code Category"] = valueGreen;
	            item006.Update();

	            // Update the list
	            list.Update();

	            // Set each the moderation status of each item to approved
	            item001.ModerationInformation.Status = SPModerationStatusType.Approved;
	            item001.Update();
	            item002.ModerationInformation.Status = SPModerationStatusType.Approved;
	            item002.Update();
	            item003.ModerationInformation.Status = SPModerationStatusType.Approved;
	            item003.Update();
	            item004.ModerationInformation.Status = SPModerationStatusType.Approved;
	            item004.Update();
	            item005.ModerationInformation.Status = SPModerationStatusType.Approved;
	            item005.Update();
	            item006.ModerationInformation.Status = SPModerationStatusType.Approved;
	            item006.Update();

	            // Create a generic list of field names for the URL fields of the catalog list
	            var urlFields = new List<string>();
	            urlFields.Add("Title");
	            urlFields.Add("Item Number");

	            // Create a CatalogTaxonomyFieldSettings object to configure the navigation hierarchy of the catalog list
	            var taxFieldSetting = new CatalogTaxonomyFieldSettings();
	            field = list.Fields["Code Category"] as TaxonomyField;
	            taxFieldSetting.TermId = field.AnchorId;
	            taxFieldSetting.TermSetId = termSet.Id;
	            taxFieldSetting.TermStoreId = termStore.Id;
	            taxFieldSetting.FieldId = field.Id;
	            taxFieldSetting.FieldManagedPropertyName = "owstaxid" + field.InternalName;
	            taxFieldSetting.IsSelected = true;
	            taxFieldSetting.FieldDisplayName = field.StaticName;

	            // Publish the catalog list
	            PublishingCatalogUtility.PublishCatalog(site.RootWeb, list, true, urlFields, new List<CatalogTaxonomyFieldSettings>() { taxFieldSetting });
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
